import express, { Application, Request, Response } from 'express';
import userRouts from '../src/routes/userRoute/index'
import * as crypto from 'crypto';

const secretKey = crypto.randomBytes(32).toString('hex');

console.log(`Your secret key: ${secretKey}`);
const app: Application = express();
const PORT = process.env.PORT || 3000;

app.use(express.json());
app.use('/api', userRouts)

app.get('/', (req: Request, res: Response) => {
  res.send('Hello World!');
});

app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
